#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]	
	public class DAL_WorkloadEvent : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetWorkloadProcessGuidByProcessID_Pass()
		{
			DataTable dtTest = DAL.WorkloadEvent.GetWorkloadProcessGuidByProcessID(1);

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcessGuid), TABLES.WorkloadProcess.WorkloadProcessGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WeightMultiplier), TABLES.WorkloadProcess.WeightMultiplier);
		}

		[Test]
		public void GetWorkloadProcessGuidByProcessID_Fail()
		{
			DataTable dtTest = DAL.WorkloadEvent.GetWorkloadProcessGuidByProcessID(-4);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetDivisionWorkloadReport_Pass()
		{
			DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(Common.LogonUser.LogonUserDivisionCode);
			DataTable dtTest1 = DAL.WorkloadEvent.GetDivisionWorkloadReport(true, currentDate.AddDays(-30), currentDate, this.TestDivisionCode);
			DataTable dtTest2 = DAL.WorkloadEvent.GetDivisionWorkloadReport(false, currentDate.AddDays(-30), currentDate, this.TestDivisionCode);

			Assert.AreEqual(7, dtTest1.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest1.Columns.Count <= dtTest2.Columns.Count, "Rows.Count");
			
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.VbecsProcess.VbecsProcessName), TABLES.VbecsProcess.VbecsProcessName);
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.VbecsProcess.TransactionType), TABLES.VbecsProcess.TransactionType);
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.WorkloadProcess.WorkloadCode), TABLES.WorkloadProcess.WorkloadCode);
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.WorkloadEvent.DivisionCode), TABLES.WorkloadEvent.DivisionCode);
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName);
			
			Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.WorkloadEvent.WeightMultiplier), TABLES.WorkloadEvent.WeightMultiplier);
            Assert.AreEqual(true, dtTest1.Columns.Contains(TABLES.WorkloadEventStatus.WorkloadEventStatusText), TABLES.WorkloadEventStatus.WorkloadEventStatusText);
			
		}

		[Test]
		public void GetDivisionWorkloadReport_Fail()
		{
			DataTable dtTest = DAL.WorkloadEvent.GetDivisionWorkloadReport(true, System.DateTime.Now, System.DateTime.Now.AddDays(-1), "Doggy");
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}
#endif
